<?php
/**
 * @package    J-BusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com/
 * @copyright  Copyright (C) 2007 - 2022 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

 use Joomla\CMS\Router;

// no direct access
defined('_JEXEC') or die;

/**
 * Class to create and parse routes for the site application
 */
class JCLSRouter extends JRouterSite{

    var $params;

    public function __construct($params = array()) {
        $this->params = $params;
    }

    /**
     * Parse URI params
     *
     * @param $router
     * @param $uri
     * @return void
     */
    public function parseRule(&$router, &$uri){

        $params = $this->getRouteParams();

        $uriAllowedVars =  array('option','view','id','Itemid');
        if (!empty($params)) {
			foreach ($params as $key => $param) {
                if(in_array($key, $uriAllowedVars)){
				    $uri->setVar($key, $param);
                }
			}
            $uri->setPath("");
		}
    }

    /**
     * 
     */
    public function buildRule(&$router, &$uri){
    }

    /**
     *  parse the URL and get the JBD associated params
     */
    public function getRouteParams(){
        $appSettings = JAdsUtil::getApplicationSettings();
		if (!$appSettings->enable_seo) {
			return;
		}
		
		$url = str_replace(JAdsUtil::getWebsiteURL(true), "", JURI::current());
		$url = "/".$url;
		$url = str_replace("/index.php", "", $url);
		$url = str_replace("index.php", "", $url);
		
		$jinput = JFactory::getApplication()->input;
		$view = $jinput->get->getString("view", null);
		$task = $jinput->get->getString("task", null);
		
		if (!empty($view) || !empty($task)) {
			return;
		}
		
		$category = null;
		$keyword = null;

		$lang = JAdsUtil::getCurrentLanguageCode();
		$url = str_replace("/".$lang."/","",$url);
		if(!empty($appSettings->url_menu_alias)){
			$url = str_replace($appSettings->url_menu_alias."/","",$url);
		}
		
		if(strpos($url,"/") === 0){
			$url = substr($url,1);
		}

		$pieces = explode("/", $url);
		if (count($pieces)>1) {
			$keyword= end($pieces);
			$category = reset($pieces);
		} else {
			$keyword = $url;
		}
		
		if (strpos($keyword, "?")) {
			$arr = explode("?", $keyword);
			$keyword = $arr[0];
		}
		
		if (strpos($keyword, "&")) {
			$arr = explode("&", $keyword);
			$keyword = $arr[0];
		}

		if (strpos($keyword, "&?")) {
			$arr = explode("&", $keyword);
			$keyword = $arr[0];
		}

		$params = array();

		if($category==CATEGORY_URL_NAMING){
			$params = $this->getCategoryParms($keyword);
		}else if($category==AD_URL_NAMING){
			$params = $this->getAdParms( $keyword);
		}

        return $params;
    }

	/**
	* getCategoryParms (Creates  the url parameters by getting the category id)
	* @param  categoryName
	* @return params
	* 
	*/
	
	function getCategoryParms($categoryName){
		$params = JFactory::getApplication()->input->get->getArray();
		$db = JFactory::getDBO();
		$appSettings = JAdsUtil::getApplicationSettings();

		$category = null;
		if($appSettings->enable_id_url == 1){ //Search the category in base of category id
			$categoryId = substr($categoryName, 0, strpos($categoryName, "-"));
			$categoryAlias = substr($categoryName, strpos($categoryName, "-")+1);
			$categoryAlias = urldecode($categoryAlias);
				
			if(!is_numeric($categoryId) || empty($categoryId)){
				return;
			}
			$query= "SELECT * FROM #__classifiedsmanager_category c where c.id = $categoryId ";
			$db->setQuery($query, 0, 1);
			$category = $db->loadObject();
		}else{//Search the category in base of the alias 
			$categoryAlias = urldecode($categoryName);
			$categoryAlias = $db->escape($categoryAlias);
			$query= "SELECT * FROM #__classifiedsmanager_category c where c.alias = '$categoryAlias' ";
			$db->setQuery($query, 0, 1);
			$category = $db->loadObject();
			$categoryId = $category->id;
		}
	
		if(!empty($category) && strcmp(strtolower($categoryAlias), (strtolower($category->alias)))==0 && !empty($category->alias)){
			$params["option"] = "com_jclassifiedsmanager";
			$params["view"] = "displayads";
			$params["controller"] = "displayads";
			$params["task"] = "displayads.searchAds";
			$params["categorySearch"] = $categoryId;
			$this->setMenuItemId();

		}
	
		return $params;
	}
	

	/**
	* getAdParms (Creates  the url parameters by getting the ad parameters)
	* @param  adname
	* @return params
	* 
	*/

	function getAdParms($adName){
		$params = JFactory::getApplication()->input->get->getArray();
		$db = JFactory::getDBO();
		$appSettings = JAdsUtil::getApplicationSettings();

		$ad = null;
		if($appSettings->enable_id_url == 1){ //Search the Ad in base of ad id
			$adId = substr($adName, 0, strpos($adName, "-"));
			$adAlias = substr($adName, strpos($adName, "-")+1);
			$adAlias = urldecode($adAlias);
				
			if(!is_numeric($adId) || empty($adId)){
				return;
			}
			$query= "SELECT * FROM #__classifiedsmanager_ads c where c.id = $adId ";
			$db->setQuery($query, 0, 1);
			$ad = $db->loadObject();
		}else{//Search the Ad in base of the alias 
			$adAlias = urldecode($adName);
			$adAlias = $db->escape($adAlias);
		
			$query= "SELECT * FROM #__classifiedsmanager_ads c where c.alias = '$adAlias' ";
			$db->setQuery($query, 0, 1);
			$ad = $db->loadObject();
			$adId = $ad->id;
		}

		
		if(!empty($ad) && strcmp(strtolower($adAlias), (strtolower($ad->alias)))==0 && !empty($ad->alias)){
			$params["option"] = "com_jclassifiedsmanager";
			$params["controller"] = "displayad";
			$params["view"] = "displayad";
			$params["task"] = "displayad";
			$params["layout"] = "default";
			$params["id"] = $adId;
			$this->setMenuItemId();
		}
	
		return $params;
	}

    
	/**
	 * Set the menu item id based on current menu item id and menu id from general settings
	 *
	 */
	public function setMenuItemId($defaultMenuItemId = null) {
		$appSettings = JAdsUtil::getApplicationSettings();
		$session = JFactory::getSession();
		//setting menu item Id
		$lang = JFactory::getLanguage();
		$app = JFactory::getApplication();
		$menu = $app->getMenu();
		$activeMenu = $app->getMenu()->getActive();
		
		$url = $_SERVER['REQUEST_URI'];
		$urlParts = parse_url($url);
		$menuId="";
		
		$menuItemId = $defaultMenuItemId;
				
		if (empty($defaultMenuItemId)) {
			$menuItemId = $appSettings->menu_item_id;
		}
		
		if ((!empty($activeMenu) && $menu->getActive() != $menu->getDefault($lang->getTag()))
				|| ($urlParts["path"]=='/' && empty($urlParts["query"]))) {
			$menuId = $activeMenu->id;
			$session->set('menuId', $menuId);
		}
		
		if ($appSettings->enable_seo) {
			$menuId = $session->get('menuId');
		}
		
		if (!empty($menuItemId) && ($menuId == $menu->getDefault($lang->getTag())->id || empty($menuId))) {
			$menuId = $menuItemId;
		}
		
		if (!empty($defaultMenuItemId)) {
			$menuId = $defaultMenuItemId;
		}
		
		if (!empty($menuId)) {
			if (JLanguageAssociations::isEnabled()) {
				$associations = JLanguageAssociations::getAssociations('com_menus', '#__menu', 'com_menus.item', $menuId, 'id', '', '');
				if (!empty($associations["{$lang->getTag()}"]->id)) {
					JFactory::getApplication()->getMenu()->setActive($associations["{$lang->getTag()}"]->id);
					JFactory::getApplication()->input->set('Itemid', $associations["{$lang->getTag()}"]->id);
				} else {
					JFactory::getApplication()->getMenu()->setActive($menuId);
					JFactory::getApplication()->input->set('Itemid', $menuId);
				}
			} else {
				JFactory::getApplication()->getMenu()->setActive($menuId);
				JFactory::getApplication()->input->set('Itemid', $menuId);
			}
		}
	}

	/**
	 * Remove all unwanted parameters from the alias
	 *
	 * @param $alias
	 * @return false|string
	 */
	private function cleanAlias($alias) {
		if (strpos($alias, "&")!== false) {
			$alias=substr($alias, 0, strpos($alias, "&"));
		}

		if (strpos($alias, "?")!== false) {
			$alias=substr($alias, 0, strpos($alias, "?"));
		}

		return $alias;
	}
}
